/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.property;

import filenet.vw.api.VWMapNode;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.runtime.property.VWBaseStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWLaunchStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWQueueUserStepPropPanel;
import filenet.vw.toolkit.runtime.property.VWStepPropTabPanel;
import filenet.vw.toolkit.runtime.property.resources.VWResource;
import filenet.vw.toolkit.utils.VWStringUtils;
import filenet.vw.toolkit.utils.uicontrols.border.VWToolbarBorder;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Locale;
import javax.swing.Box;
import javax.swing.DefaultComboBoxModel;
import javax.swing.DefaultListModel;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class VWStepRulePanel
extends VWStepPropTabPanel
implements ActionListener {
    private VWMapNode m_mapNode = null;
    private String[] m_beforeRuleSetNames = null;
    private String[] m_onSaveRuleSetNames = null;
    private String[] m_afterRuleSetNames = null;
    private boolean m_bBeforeRuleType = false;
    private boolean m_bOnSaveRuleType = false;
    private boolean m_bAfterRuleType = false;
    private JLabel m_ruleNameLabel = null;
    private JComboBox m_ruleTypeCombo = null;
    private DefaultComboBoxModel m_ruleTypeComboModel = null;
    private JList m_ruleSetsList = null;
    private DefaultListModel m_ruleSetsListModel = new DefaultListModel();

    public VWStepRulePanel(Frame parentFrame, VWBaseStepPropPanel propPanel) {
        super(parentFrame, propPanel);
        if (!(propPanel instanceof VWLaunchStepPropPanel)) {
            this.m_bBeforeRuleType = true;
        }
        if (propPanel instanceof VWQueueUserStepPropPanel) {
            this.m_bOnSaveRuleType = true;
        }
        this.m_bAfterRuleType = true;
        this.m_type = 8;
        this.preSetupLayout();
    }

    public void removeReferences() {
        super.removeReferences();
        this.m_ruleSetsList = null;
        this.m_ruleSetsListModel = null;
        this.m_ruleTypeCombo = null;
        this.m_ruleTypeComboModel = null;
        this.removeAll();
    }

    public void actionPerformed(ActionEvent event) {
        if (event.getSource().equals(this.m_ruleTypeCombo)) {
            String selectedRuleType = (String)this.m_ruleTypeCombo.getSelectedItem();
            this.initRuleSetsModel(this.getProperRuleSetsDef(selectedRuleType));
        }
    }

    protected void initData() throws Exception {
        if (this.isInitialized()) {
            return;
        }
        try {
            if (this.m_step != null) {
                this.m_mapNode = this.m_step.getMapNode();
                if (this.m_bBeforeRuleType) {
                    this.m_beforeRuleSetNames = this.m_mapNode.getRuleSetNames(0);
                }
                if (this.m_bOnSaveRuleType) {
                    this.m_onSaveRuleSetNames = this.m_mapNode.getRuleSetNames(1);
                }
                if (this.m_bAfterRuleType) {
                    this.m_afterRuleSetNames = this.m_mapNode.getRuleSetNames(2);
                }
            } else {
                this.m_mapNode = null;
                this.m_beforeRuleSetNames = null;
                this.m_onSaveRuleSetNames = null;
                this.m_afterRuleSetNames = null;
            }
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
            throw ex;
        }
    }

    protected void preSetupLayout() {
        JPanel rulePanel = new JPanel();
        GridBagConstraints c = new GridBagConstraints();
        Insets insets = new Insets(0, 4, 0, 4);
        Insets nullInsets = new Insets(0, 0, 0, 0);
        VWToolbarBorder ruleBorder = null;
        JScrollPane scrollPane = null;
        ruleBorder = new VWToolbarBorder(VWResource.s_ruleSets, 0);
        rulePanel = ruleBorder.getClientPanel();
        rulePanel.setLayout(new BorderLayout());
        if (this.m_ruleSetsList == null) {
            this.m_ruleSetsList = new JList(this.m_ruleSetsListModel);
        }
        scrollPane = new JScrollPane(this.m_ruleSetsList);
        scrollPane.setPreferredSize(new Dimension(10, 50));
        this.setLayout(new GridBagLayout());
        c.anchor = 23;
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.weightx = 1.0;
        c.anchor = 23;
        c.fill = 2;
        c.insets = new Insets(0, 4, 8, 4);
        this.add((Component)this.createRuleTypePanel(), c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 0;
        c.gridheight = 1;
        c.fill = 1;
        c.insets = insets;
        this.add((Component)ruleBorder, c);
        c.gridx = 0;
        ++c.gridy;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.fill = 3;
        c.weightx = 0.0;
        c.weighty = 0.3;
        c.insets = nullInsets;
        this.add(Box.createVerticalStrut(300), c);
        c.gridx = 1;
        c.weighty = 0.0;
        this.add(Box.createVerticalStrut(150), c);
        c.gridx = 2;
        c.gridwidth = 0;
        c.fill = 1;
        c.weightx = 1.0;
        c.weighty = 0.0;
        c.insets = insets;
        this.add((Component)scrollPane, c);
        ComponentOrientation compOrientation = ComponentOrientation.getOrientation(Locale.getDefault());
        this.applyComponentOrientation(compOrientation);
    }

    protected void setupLayout() {
        this.updateDisplay();
    }

    protected void updateDisplay() {
        this.initRuleComboModel();
        if (this.m_ruleTypeCombo != null && this.m_ruleTypeComboModel.getSize() > 0) {
            this.m_ruleTypeCombo.setSelectedIndex(0);
            String selectedRuleType = (String)this.m_ruleTypeCombo.getSelectedItem();
            this.initRuleSetsModel(this.getProperRuleSetsDef(selectedRuleType));
        } else {
            this.m_ruleTypeCombo.setSelectedIndex(-1);
            this.initRuleSetsModel(null);
        }
        this.updateUI();
    }

    private JPanel createRuleTypePanel() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridBagLayout());
        GridBagConstraints c = new GridBagConstraints();
        this.m_ruleNameLabel = new JLabel(VWResource.s_typeLabel);
        this.m_ruleTypeComboModel = new DefaultComboBoxModel();
        this.m_ruleTypeCombo = new JComboBox(this.m_ruleTypeComboModel);
        this.m_ruleTypeCombo.addActionListener(this);
        c.gridx = 0;
        c.gridy = 0;
        c.gridwidth = 1;
        c.gridheight = 1;
        c.anchor = 23;
        c.fill = 0;
        panel.add((Component)this.m_ruleNameLabel, c);
        c.gridx = 1;
        c.fill = 2;
        c.weightx = 1.0;
        c.insets = new Insets(0, 6, 0, 4);
        this.m_ruleTypeCombo.setPreferredSize(new Dimension(40, 20));
        panel.add((Component)this.m_ruleTypeCombo, c);
        return panel;
    }

    private void initRuleComboModel() {
        if (this.m_ruleTypeCombo == null) {
            return;
        }
        if (this.m_ruleTypeComboModel == null) {
            this.m_ruleTypeComboModel = new DefaultComboBoxModel();
            this.m_ruleTypeCombo.setModel(this.m_ruleTypeComboModel);
        } else {
            this.m_ruleTypeComboModel.removeAllElements();
        }
        if (this.m_bBeforeRuleType) {
            this.m_ruleTypeComboModel.addElement(VWResource.s_beforeExecution);
        }
        if (this.m_bOnSaveRuleType) {
            this.m_ruleTypeComboModel.addElement(VWResource.s_onSave);
        }
        if (this.m_bAfterRuleType) {
            this.m_ruleTypeComboModel.addElement(VWResource.s_afterCompletion);
        }
        if (this.m_ruleTypeComboModel.getSize() == 0) {
            this.m_ruleTypeComboModel.addElement(VWResource.s_none);
        }
    }

    private void initRuleSetsModel(String[] ruleSetNames) {
        if (this.m_ruleSetsList == null) {
            return;
        }
        if (this.m_ruleSetsListModel == null) {
            this.m_ruleSetsListModel = new DefaultListModel();
            this.m_ruleSetsList.setModel(this.m_ruleSetsListModel);
        } else {
            this.m_ruleSetsListModel.removeAllElements();
        }
        if (ruleSetNames != null) {
            for (int i = 0; i < ruleSetNames.length; ++i) {
                this.m_ruleSetsListModel.addElement(ruleSetNames[i]);
            }
        }
    }

    private String[] getProperRuleSetsDef(String selectedRuleType) {
        String[] tmpRuleSetNames = null;
        if (VWStringUtils.compareIgnoreCase(selectedRuleType, VWResource.s_beforeExecution) == 0) {
            tmpRuleSetNames = this.m_beforeRuleSetNames;
        } else if (VWStringUtils.compareIgnoreCase(selectedRuleType, VWResource.s_onSave) == 0) {
            tmpRuleSetNames = this.m_onSaveRuleSetNames;
        } else if (VWStringUtils.compareIgnoreCase(selectedRuleType, VWResource.s_afterCompletion) == 0) {
            tmpRuleSetNames = this.m_afterRuleSetNames;
        }
        return tmpRuleSetNames;
    }
}

